-----------------------------------------------------------------------------------
/*
Vjebe se rade na bazi AdventureWorksOBP
*/
USE AdventureWorksOBP
GO
-----------------------------------------------------------------------------------

-----------------------------------------------------------------------------------
/* N A P O M E N A
Kod rjeavanja zadataka s transakcijama 
potrebne su dvije SQL skripte, svaka u 
svojoj konekciji te svaka SQL naredba 
treba sadravati redni broj izvravanja
*/
-----------------------------------------------------------------------------------

-----------------------------------------------------------------------------------
-- Zadatak 1.
/*
IZOLACIJSKI NIVOI (1) - SKRIPTA 2
Demonstrirajte problem prljavog itanja na tablici Drzava na retku s IDDrzava = 3. 
Napiite gdje se desilo prljavo itanje.
*/
-- TRANSAKCIJA 2.
-- KORACI KOJI NEDOSTAJU IZVRAVAJU SE U PRVOJ SKRIPTI
-- 2.
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
-- 4. 
BEGIN TRAN
-- 6.
SELECT * FROM Drzava WHERE IDDrzava = 3 -- Prljavo itanje.
-- 8.
ROLLBACK TRAN
-----------------------------------------------------------------------------------

-----------------------------------------------------------------------------------
-- Zadatak 2.
/*
IZOLACIJSKI NIVOI (1) - SKRIPTA 2
Demonstrirajte rjeenje problem prljavog itanja na tablici Drzava na retku s IDDrzava = 3. 
Napiite gdje bi se desilo prljavo itanje i kako ste to sprijeili.
*/
-- TRANSAKCIJA 2.
-- KORACI KOJI NEDOSTAJU IZVRAVAJU SE U PRVOJ SKRIPTI
-- 2.
SET TRANSACTION ISOLATION LEVEL READ COMMITTED -- Prljavo itanje sprjeavamo postavljanjem bilo kojeg izolacijskog nivoa iznad READ UNCOMMITTED.
-- 4. 
BEGIN TRAN
-- 6.
SELECT * FROM Drzava WHERE IDDrzava = 3 -- Blokiranje umjesto prljavog itanja.
-- 8.
ROLLBACK TRAN
-----------------------------------------------------------------------------------

-----------------------------------------------------------------------------------
-- Zadatak 3.
/*
IZOLACIJSKI NIVOI (2) - SKRIPTA 2
Demonstrirajte problem neponovljivog itanja na tablici Drzava na retku s IDDrzava = 3. 
Napiite gdje se desilo neponovljivo itanje.
*/
-- TRANSAKCIJA 2.
-- KORACI KOJI NEDOSTAJU IZVRAVAJU SE U PRVOJ SKRIPTI
-- 2.
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
-- 4. 
BEGIN TRAN
-- 6.
UPDATE Drzava SET Naziv = 'Bosna i Hercegovina' WHERE IDDrzava = 3
-- 7.
COMMIT TRAN
-----------------------------------------------------------------------------------

-----------------------------------------------------------------------------------
-- Zadatak 4.
/*
IZOLACIJSKI NIVOI (2) - SKRIPTA 2
Demonstrirajte rjeenje problema neponovljivog itanja na tablici Drzava na retku s IDDrzava = 3. 
Napiite gdje bi se desilo neponovljivo itanje.
*/
-- TRANSAKCIJA 2.
-- KORACI KOJI NEDOSTAJU IZVRAVAJU SE U PRVOJ SKRIPTI
-- 2.
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
-- 4. 
BEGIN TRAN
-- 6.
UPDATE Drzava SET Naziv = 'Hrv' WHERE IDDrzava = 1 -- Blokiran zbog S lokota.
-- 9.
ROLLBACK TRAN

-----------------------------------------------------------------------------------

-----------------------------------------------------------------------------------
-- Zadatak 5.
/*
IZOLACIJSKI NIVOI (2) - SKRIPTA 2
Demonstrirajte problem fantoma na tablici Drzava 
na recima s nazivima koji zapoinju s 'H'. 
Napiite gdje se pojavljuju fantomi.
*/
-- TRANSAKCIJA 2.
-- KORACI KOJI NEDOSTAJU IZVRAVAJU SE U PRVOJ SKRIPTI
-- 2.
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
-- 4. 
BEGIN TRAN
-- 6.
INSERT INTO Drzava (Naziv) VALUES ('Honduras')
-- 7.
COMMIT TRAN
-----------------------------------------------------------------------------------

-----------------------------------------------------------------------------------
-- Zadatak 6.
/*
IZOLACIJSKI NIVOI (2) - SKRIPTA 2
Demonstrirajte rjeenje problema fantoma na tablici Drzava 
na recima s nazivima koji zapoinju s 'H'. 
Napiite gdje bi se pojavili fantomi.
*/
-- TRANSAKCIJA 2.
-- KORACI KOJI NEDOSTAJU IZVRAVAJU SE U PRVOJ SKRIPTI
-- 2.
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
-- 4. 
BEGIN TRAN
-- 6.
INSERT INTO Drzava (Naziv) VALUES ('Haiti') -- Blokiran zbog S lokota. Da nije, umetnuo bi fantoma.
-- 9.
ROLLBACK TRAN
-----------------------------------------------------------------------------------
